/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.custom_libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;
import technology.rocketjump.undermount.rendering.custom_libgdx.ShaderLoader;

public class AlphaMaskSpriteBatch {
    private Mesh mesh;
    final float[] vertices;
    int idx = 0;
    Texture colorTexture = null;
    Texture alphaTexture = null;
    float invColorTexWidth = 0.0f;
    float invAlphaTextureWidth = 0.0f;
    float invColorTexHeight = 0.0f;
    float invAlphaTexHeight = 0.0f;
    boolean drawing = false;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private final ShaderProgram shader;
    private boolean ownsShader;
    float color = Color.WHITE.toFloatBits();
    private Color tempColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    public int maxSpritesInBatch = 0;

    public AlphaMaskSpriteBatch() {
        int size = 1000;
        if (size > 5460) {
            throw new IllegalArgumentException("Can't have more than 5460 sprites per batch: " + size);
        }
        this.mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(16, 2, "a_texCoord1"));
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        int SPRITE_SIZE = 28;
        this.vertices = new float[size * 28];
        int indicesLength = size * 6;
        short[] indices = new short[indicesLength];
        short j = 0;
        int i = 0;
        while (i < indicesLength) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        FileHandle vertexShaderFile = Gdx.files.classpath("shaders/alpha_mask_blending_vertex_shader.glsl");
        FileHandle fragmentShaderFile = Gdx.files.classpath("shaders/alpha_mask_blending_fragment_shader.glsl");
        this.shader = ShaderLoader.createShader(vertexShaderFile, fragmentShaderFile);
        this.ownsShader = true;
    }

    protected void setTextures(Texture colorTexture, Texture alphaTexture) {
        this.flush();
        this.colorTexture = colorTexture;
        this.alphaTexture = alphaTexture;
        this.invColorTexWidth = 1.0f / (float)colorTexture.getWidth();
        this.invColorTexHeight = 1.0f / (float)colorTexture.getHeight();
        this.invAlphaTextureWidth = 1.0f / (float)alphaTexture.getWidth();
        this.invAlphaTexHeight = 1.0f / (float)alphaTexture.getHeight();
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("SpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.gl.glDepthMask(false);
        this.shader.begin();
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.drawing = false;
        GL20 gl = Gdx.gl;
        gl.glDepthMask(true);
        gl.glDisable(3042);
        this.shader.end();
    }

    public void setColor(Color tint) {
        this.color = tint.toFloatBits();
    }

    public void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    public void setColor(float color) {
        this.color = color;
    }

    public Color getColor() {
        int intBits = NumberUtils.floatToIntColor(this.color);
        Color color = this.tempColor;
        color.r = (float)(intBits & 0xFF) / 255.0f;
        color.g = (float)(intBits >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(intBits >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(intBits >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    public float getPackedColor() {
        return this.color;
    }

    public void draw(Sprite colorSprite, Sprite alphaSprite, float x, float y, float width, float height) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] vertices = this.vertices;
        if (colorSprite.getTexture() != this.colorTexture || alphaSprite.getTexture() != this.alphaTexture) {
            this.setTextures(colorSprite.getTexture(), alphaSprite.getTexture());
        }
        if (this.idx == vertices.length) {
            this.flush();
        }
        float fx2 = x + width;
        float fy2 = y + height;
        float color_u = colorSprite.getU();
        float color_v = colorSprite.getV2();
        float color_u2 = colorSprite.getU2();
        float color_v2 = colorSprite.getV();
        float alpha_u = alphaSprite.getU();
        float alpha_v = alphaSprite.getV2();
        float alpha_u2 = alphaSprite.getU2();
        float alpha_v2 = alphaSprite.getV();
        vertices[this.idx++] = x;
        vertices[this.idx++] = y;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = color_u;
        vertices[this.idx++] = color_v;
        vertices[this.idx++] = alpha_u;
        vertices[this.idx++] = alpha_v;
        vertices[this.idx++] = x;
        vertices[this.idx++] = fy2;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = color_u;
        vertices[this.idx++] = color_v2;
        vertices[this.idx++] = alpha_u;
        vertices[this.idx++] = alpha_v2;
        vertices[this.idx++] = fx2;
        vertices[this.idx++] = fy2;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = color_u2;
        vertices[this.idx++] = color_v2;
        vertices[this.idx++] = alpha_u2;
        vertices[this.idx++] = alpha_v2;
        vertices[this.idx++] = fx2;
        vertices[this.idx++] = y;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = color_u2;
        vertices[this.idx++] = color_v;
        vertices[this.idx++] = alpha_u2;
        vertices[this.idx++] = alpha_v;
    }

    public void draw(Sprite colorSprite, Sprite alphaSprite, float x, float y, float width, float height, float[] vertexColors) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] vertices = this.vertices;
        if (colorSprite.getTexture() != this.colorTexture || alphaSprite.getTexture() != this.alphaTexture) {
            this.setTextures(colorSprite.getTexture(), alphaSprite.getTexture());
        }
        if (this.idx == vertices.length) {
            this.flush();
        }
        float fx2 = x + width;
        float fy2 = y + height;
        float color_u = colorSprite.getU();
        float color_v = colorSprite.getV2();
        float color_u2 = colorSprite.getU2();
        float color_v2 = colorSprite.getV();
        float alpha_u = alphaSprite.getU();
        float alpha_v = alphaSprite.getV2();
        float alpha_u2 = alphaSprite.getU2();
        float alpha_v2 = alphaSprite.getV();
        vertices[this.idx++] = x;
        vertices[this.idx++] = y;
        vertices[this.idx++] = vertexColors[0];
        vertices[this.idx++] = color_u;
        vertices[this.idx++] = color_v;
        vertices[this.idx++] = alpha_u;
        vertices[this.idx++] = alpha_v;
        vertices[this.idx++] = x;
        vertices[this.idx++] = fy2;
        vertices[this.idx++] = vertexColors[1];
        vertices[this.idx++] = color_u;
        vertices[this.idx++] = color_v2;
        vertices[this.idx++] = alpha_u;
        vertices[this.idx++] = alpha_v2;
        vertices[this.idx++] = fx2;
        vertices[this.idx++] = fy2;
        vertices[this.idx++] = vertexColors[2];
        vertices[this.idx++] = color_u2;
        vertices[this.idx++] = color_v2;
        vertices[this.idx++] = alpha_u2;
        vertices[this.idx++] = alpha_v2;
        vertices[this.idx++] = fx2;
        vertices[this.idx++] = y;
        vertices[this.idx++] = vertexColors[3];
        vertices[this.idx++] = color_u2;
        vertices[this.idx++] = color_v;
        vertices[this.idx++] = alpha_u2;
        vertices[this.idx++] = alpha_v;
    }

    public void flush() {
        if (this.idx == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int spritesInBatch = this.idx / 28;
        if (spritesInBatch > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = spritesInBatch;
        }
        int count = spritesInBatch * 6;
        this.alphaTexture.bind(1);
        this.colorTexture.bind(0);
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(count);
        Gdx.gl.glEnable(3042);
        if (this.blendSrcFunc != -1) {
            Gdx.gl.glBlendFunc(this.blendSrcFunc, this.blendDstFunc);
        }
        mesh.render(this.shader, 4, 0, count);
        this.idx = 0;
    }

    public void setBlendFunction(int srcFunc, int dstFunc) {
        if (this.blendSrcFunc == srcFunc && this.blendDstFunc == dstFunc) {
            return;
        }
        this.flush();
        this.blendSrcFunc = srcFunc;
        this.blendDstFunc = dstFunc;
    }

    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    public void dispose() {
        this.mesh.dispose();
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setProjectionMatrix(Matrix4 projection) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(projection);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    public void setTransformMatrix(Matrix4 transform) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(transform);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformi("u_texture1", 1);
    }

    public void setShader(ShaderProgram shader) {
        if (this.drawing) {
            this.flush();
            this.shader.end();
            this.shader.begin();
            this.setupMatrices();
        }
    }

    public boolean isDrawing() {
        return this.drawing;
    }
}

